function loadPage(event) {
    event.preventDefault(); // Verhindert das Standardverhalten des Formulars

    var num = document.getElementById("searchField").value;
    var imageFolder = 'bibliothek/' + num + '/';

    var image1Frame = document.getElementById("imageFrame1").contentWindow.document;
    var image2Frame = document.getElementById("imageFrame2").contentWindow.document;
    var image3Frame = document.getElementById("additionalImageFrame").contentWindow.document;

    loadImage(image1Frame, imageFolder + 'L.jpg', 'images/default.jpg');
    loadImage(image2Frame, imageFolder + 'R.jpg', 'images/default.jpg');
    loadImage(image3Frame, imageFolder + num + '.jpg', 'images/default.jpg');

    var pageUrl = 'bibliothek/' + num + '/' + num + '.txt';
    var iframe = document.getElementById("pageFrame");
    iframe.src = pageUrl;

    var xhr = new XMLHttpRequest();
    xhr.open('GET', pageUrl, true);
    xhr.onreadystatechange = function() {
        if (xhr.readyState === 4) {
            if (xhr.status === 404 || xhr.status === 403) {
                loadDefaultText(iframe);
            } else {
                iframe.onload = function() {
                    if (iframe.contentDocument.body.innerHTML.trim().length === 0) {
                        loadDefaultText(iframe);
                    } else {
                        document.getElementById("dataContainer").style.display = "block";
                        document.getElementById("calendar-container").style.display = "none"; // Verstecke den Kalender
                        updateButtonState(); // Button-Status aktualisieren
                    }
                };
                document.getElementById("dataContainer").style.display = "block";
                document.getElementById("calendar-container").style.display = "none"; // Verstecke den Kalender
                updateButtonState(); // Button-Status aktualisieren
            }
        }
    };
    xhr.send();
}

function loadDefaultText(iframe) {
    iframe.contentWindow.document.body.innerHTML = "Die angeforderte Seite konnte nicht gefunden werden.";
}
